VERSION 5.00
Begin VB.Form Form1 
   BorderStyle     =   3  'Fester Dialog
   Caption         =   "Metafiles"
   ClientHeight    =   2244
   ClientLeft      =   48
   ClientTop       =   336
   ClientWidth     =   4188
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   2244
   ScaleWidth      =   4188
   StartUpPosition =   2  'Bildschirmmitte
   Begin VB.CommandButton Command1 
      Caption         =   "Create PDF"
      Height          =   735
      Left            =   720
      TabIndex        =   0
      Top             =   660
      Width           =   2775
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Private Declare Function ShellExecuteA Lib "shell32.dll" (ByVal hWnd As Long, ByVal lpOperation As String, ByVal lpFile As String, ByVal lpParameters As String, ByVal lpDirectory As String, ByVal nShowCmd As Long) As Long
Private WithEvents pdf As CPDF 'Activate event support
Attribute pdf.VB_VarHelpID = -1

Private Sub pdf_Error(ByVal Description As String, ByVal ErrType As Long, DoBreak As Boolean)
   MsgBox Description, vbExclamation, "Error"
   DoBreak = True ' We break processing if an error occurred!
End Sub

Private Sub Form_Load()
   On Error GoTo Err
   Set pdf = New CPDF
   Exit Sub
Err:
   MsgBox "Out of memory!", vbCritical, "Fatal error"
End Sub

Private Sub Form_Terminate()
   Set pdf = Nothing
End Sub

Private Sub PlaceEMFCentered(ByVal FileName As String, ByVal Width As Double, ByVal Height As Double)
   Dim r As TRectL
   Dim x As Double
   Dim y As Double
   Dim w As Double
   Dim h As Double
   Dim sx As Double

   ' We place the EMF file horizontal and vertically centered in this example.

   ' We need the picture size of the EMF file
   If Not pdf.GetLogMetafileSize(FileName, r) Then Exit Sub
   w = r.rRight - r.rLeft
   h = r.rBottom - r.rTop
   ' We place the EMF file into a border of 2 units around the page so that we can better see
   ' the bounding box of the EMF file.
   Width = Width - 4#
   Height = Height - 4#
   sx = Width / w
   ' An important note about the bounding rectangle: DynaPDF calculates the zero point
   ' of the EMF picture automatically so that we don't need to consider the coordinate origin.
   ' The coordinate origin for our calculation here is always 0.0, 0.0 independent of the real
   ' origin of the EMF picture.
   If h * sx <= Height Then
      h = h * sx
      x = 2#
      ' If the file should not be centered vertically set y to 2.0.
      y = (Height - h) / 2#
      pdf.InsertMetafile FileName, x, y, Width, 0#
      ' The rectangle represents the real bounding box of the EMF picture.
      pdf.SetStrokeColor vbRed
      pdf.Rectangle x, y, Width, h, fmStroke
   Else
      sx = Height / h
      w = w * sx
      x = (Width - w) / 2#
      y = 2#
      pdf.InsertMetafile FileName, x, y, 0#, Height
      ' The rectangle represents the real bounding box of the EMF picture.
      pdf.SetStrokeColor vbRed
      pdf.Rectangle x, y, w, Height, fmStroke
   End If
End Sub

Private Sub Command1_Click()
   ' Error messages and warnings are passed to the error event function.
   Call pdf.CreateNewPDF(vbNullString) ' The output file is opened later

   pdf.SetPageCoords pcTopDown

   pdf.Append
   'We use a landscape paper format in this example. SetOrientationEx() rotates the coordinate
   'system according to the orientation and sets the page orientation. You can now work with page
   'as if it was not rotated. The real page format is still DIN A4 (this is the default format).
   'The difference to SetOrientation() is that this function does not change the page's coordinate
   'system.

   'It would also be possible to use a user defined paper format without changing the page
   'orientation but the disadvantage is that a printer driver must then manually rotate the page
   'because landscape paper formats do not exist in most printers. This step requires an
   'additional interaction with the user which is simply not required when creating landscape
   'paper formats in the right way.
   pdf.SetOrientationEx 90

   ' This file transforms the coordinate system very often and uses clipping regions. The metafile
   ' is scaled to the page width without changing its aspect ratio.
   PlaceEMFCentered "../../test_files/coords.emf", pdf.GetPageWidth, pdf.GetPageHeight
   pdf.EndPage

   pdf.Append
   pdf.SetOrientationEx 90
   ' Simple test of line and standard patterns
   PlaceEMFCentered "../../test_files/fulltest.emf", pdf.GetPageWidth, pdf.GetPageHeight
   pdf.EndPage

   pdf.Append
   pdf.SetOrientationEx 90
   ' Outlined text, dash patterns with text. This file requires the font Bookman Old Style. If not available,
   ' the result will be wrong!
   PlaceEMFCentered "../../test_files/gdi.emf", pdf.GetPageWidth, pdf.GetPageHeight
   pdf.EndPage

   ' No fatal error occurred?
   If pdf.HaveOpenDoc Then
      ' OK, now we can open the output file.
      Dim outFile As String
      outFile = App.Path + "\out.pdf"
      If pdf.OpenOutputFile(outFile) Then
         If pdf.CloseFile Then
            ShellExecuteA Me.hWnd, "open", outFile, vbNullString, vbNullString, 1
         End If
      End If
   End If
End Sub
